import{at as r,bs as I,bt as n,bD as p}from"./index-656a8172.js";const x=`
  query PayrollSummary($year: Int, $unitId: Int) {
    payroll_summary3(year: $year, unit_id: $unitId) {
      status
      hours
      amount
      unit_id
      period {
        start
        end
        period
        display
      }
      payroll_weeks {
        id
        hours
        amount
        status
        period {
          start
          end
          period
          display
        }
      }
    }
  }
`,w=`
  query SicomEmployeePayrolls($unitId: Int, $start: String, $end: String) {
    sicom_employee_payrolls(unit_id: $unitId, start: $start, end: $end) {
      id
      firstname
      lastname
      social_security_num
      hours
      sicom_payroll_id
      unit_id
    }
  }
`,S=`
  query EmployeesForUnit($unitId: Int) {
    employees_for_unit(unit_id: $unitId) {
      id
      unit_id
      firstname
      middlename
      lastname
      birth_date
      social_security_num
      payroll_id
      address
      city
      county
      state
      zip
      country
      phone
      gender
      job_title_id
      job_title
      schedule_id
      payroll_id
      type
      wage
      marital_status
      exemptions
      status
      hire_date
      termination_date
      termination_reason
      rehire_date
      unit {
        employer_contribution
      }
    }
  }
`,$=`
  query EmployeePayrollsByPayrollId($payrollId: Int) {
    employee_payrolls_by_payroll_id(payroll_id: $payrollId) {
      id
      employee {
        firstname
        lastname
        type
        payroll_id
        wage
      }
      employee_id
      employee_type
      payroll_id
      wages
      hours
      gross_wages
      employer_contribution
      employer_liability
      total_expense
    }
  }
`,E=`
  query EmployeePayrollsAggregated($payrollIds: [Int]) {
    employee_payrolls_aggregated(payroll_ids: $payrollIds) {
      id
      employee {
        firstname
        lastname
        type
        payroll_id
        wage
      }
      employee_id
      employee_type
      wages
      hours
      gross_wages
      overtime
      weekly_hours
      weekly_gross_wages
      employer_contribution
      employer_liability
      total_expense
    }
  }
`,q=`
  query GetPayrollPeriods($unitId: Int) {
    unit_payrolls(unit_id: $unitId) {
      payroll_weeks {
        period {
          display
          start
          end
        }
      }
    }
  }
`,k=`
  mutation PayrollEntry($payrollInput: PayrollInput) {
    payroll_entry(payrollInput: $payrollInput)
}`,C=`
  mutation PayrollSetStatus($payrollId: Int!, $status: String!) {
    payroll_set_status(payroll_id: $payrollId, status: $status)
}`,F=`
  mutation PayrollDelete($payrollId: Int!) {
    payroll_delete(payroll_id: $payrollId)
}`,D=[{id:0,name:"ADP"},{id:0,name:"PayChex Online"},{id:0,name:"Paylocity"}],M=[{id:0,name:"Sunday - Monday"},{id:1,name:"Monday - Sunday"},{id:2,name:"Tuesday - MNonday"},{id:3,name:"Wednesday - Tuesday"},{id:4,name:"Thursday - Wednesday"},{id:5,name:"Friday - Thursday"},{id:6,name:"Saturday - Sunday"}],Q=[{id:1,name:"1 Week"},{id:2,name:"2 Weeks"}],_=r(null),g=r(null),h=r(null),c=r(null),P=r(null),f=r(null),v=r(null),u=r(null),b=r(null),W=I({id:"payroll",state:()=>({changeCount:0,loading:!1,payrollQueue:[],payrollSummary:[],employeePayrolls:[],sicomEmployeePayrolls:[],aggregtedEmployeePayrolls:[],payrollPeriods:[]}),actions:{setup(){const{execute:e}=n({query:x,cachePolicy:"network-only"});_.value=e;const{execute:a}=n({query:w});g.value=a;const{execute:t}=n({query:S,cachePolicy:"network-only"});h.value=t;const{execute:s}=n({query:$,cachePolicy:"network-only"});c.value=s;const{execute:y}=n({query:E,cachePolicy:"network-only"});P.value=y;const{execute:i}=n({query:q,cachePolicy:"network-only"});f.value=i;const{execute:l}=p(k);v.value=l;const{execute:o}=p(C);u.value=o;const{execute:d}=p(F);b.value=d},fetchPayrollSummary(e,a){const t={year:e,unitId:a};this.loading=!0,_.value({variables:t}).then(s=>{s.error||(this.payrollSummary=s.data.payroll_summary3)}).finally(()=>{this.loading=!1})},fetchSicomEmployeePayrolls(e){const a={unitId:e};this.loading=!0,g.value({variables:a}).then(t=>{t.error||(this.payrollPeriods=t.data.sale)}).finally(()=>{this.loading=!1})},fetchEmployeePayrolls(e){const a={payrollId:e};this.loading=!0,c.value({variables:a,cachePolicy:"network-only"}).then(t=>{t.error||(this.employeePayrolls=t.data.employee_payrolls_by_payroll_id)}).finally(()=>{this.loading=!1})},async createEmployeePayrolls(e,a,t){const s={unitId:e.id};this.loading=!0;const y=new Map;if(t>0){const i=this.payrollSummary[a].payroll_weeks[t-1].id;(await c.value({variables:{payrollId:i},cachePolicy:"network-only"}).then(o=>o.error?[]:o.data.employee_payrolls_by_payroll_id)).forEach(o=>{var d,m;(d=o.employee)!=null&&d.payroll_id&&y.set((m=o.employee)==null?void 0:m.payroll_id,o.wages)})}h.value({variables:s}).then(i=>{i.error||(this.employeePayrolls=i.data.employees_for_unit.filter(l=>l.status==="Active").map(l=>{const o=y.has(l.payroll_id)?y.get(l.payroll_id):l.wage;return{employee:l,employee_id:l.id,employee_type:l.type,wages:o,hours:0,gross_wages:l.type==="Salary"?l.wage:0,employer_contribution:e.employer_contribution,employer_liability:l.type==="Salary"?((e==null?void 0:e.employer_contribution)??12.5)*o/100:0,total_expense:l.type==="Salary"?l.wage+((e==null?void 0:e.employer_contribution)??12.5)*o/100:0}}))}).finally(()=>{this.loading=!1})},fetchAggregatedEmployeePayrolls(e){const a={payrollIds:e};this.loading=!0,P.value({variables:a}).then(t=>{t.error||(this.aggregtedEmployeePayrolls=t.data.employee_payrolls_aggregated)}).finally(()=>{this.loading=!1})},fetchPayrollPayroll(e){const a={unitId:e};this.loading=!0,f.value({variables:a}).then(t=>{t.error||(this.payrollPeriods=t.data.sale)}).finally(()=>{this.loading=!1})},updatePayrollStatus(e,a){const t={payrollId:e,status:a};this.loading=!0,u.value(t).finally(()=>{this.loading=!1})},async savePayroll(e,a,t){if(this.loading)return new Promise(l=>{this.payrollQueue.push(()=>this.savePayroll(e,a,t).then(l))});this.loading=!0;const s=t.map(l=>({id:l.id,employee_id:l.employee_id,employee_type:l.employee_type,wages:l.employee.wage,hours:l.hours,gross_wages:l.gross_wages,employer_contribution:l.employer_contribution,employer_liability:l.employer_liability,total_expense:l.total_expense})),i={payrollInput:{id:a?a.id:-1,unit_id:e.id,period:a.period.period,status:"Run",employee_payrolls:s}};try{await v.value(i),this.changeCount++}catch(l){console.error("Error saving payroll:",l)}finally{this.loading=!1;let l=this.payrollQueue.shift();for(;l;)console.error("Blocked duplicate call"),l=this.payrollQueue.shift()}},closePayroll(e){const a={payrollId:e,status:"Closed"};this.loading=!0,u.value(a).finally(()=>{this.loading=!1,this.changeCount++})},openPayroll(e){const a={payrollId:e,status:"Run"};this.loading=!0,u.value(a).finally(()=>{this.loading=!1,this.changeCount++})},finalizePayroll(e){const a={payrollId:e,status:"Finalized"};this.loading=!0,u.value(a).finally(()=>{this.loading=!1,this.changeCount++})},deletePayroll(e){const a={payrollId:e};this.loading=!0,b.value(a).finally(()=>{this.loading=!1,this.changeCount++})}},getters:{getLoading({loading:e}){return e},getChangeCount({changeCount:e}){return e},getPayrollSummary({payrollSummary:e}){return e},getPayrollPeriods({payrollPeriods:e}){return e},getEmployeePayrolls({employeePayrolls:e}){return e}}});export{M as a,Q as b,D as p,W as u};
