import { Router } from "express";
import NoticeController from "../../controller/noticeController";
import { verifyToken } from "../../middleware/verifyToken";

export default class NoticeRouter {
    readonly router: Router = Router();
    readonly controller: NoticeController = new NoticeController();
    
    constructor() {
        this.initRoutes();
    } 

    initRoutes() {
        this.router.use(verifyToken);
        this.router.post('/', this.controller.replaceAll);
        this.router.get('/', this.controller.getAll);
        this.router.delete('/expired', this.controller.deleteExpired);
    }
}