const admin = require("firebase-admin");
const fs = require("fs");

const serviceAccount = require("./serviceAccountKey.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount)
});

const db = admin.firestore();

async function exportData() {
  const collections = await db.listCollections();
  const allData = {};

  for (const collection of collections) {
    const snapshot = await collection.get();
    allData[collection.id] = snapshot.docs.map(doc => ({
      id: doc.id,
      ...doc.data(),
    }));
  }

  fs.writeFileSync("firestore-backup.json", JSON.stringify(allData, null, 2));
  console.log("✅ Export complete! Saved to firestore-backup.json");
}

exportData().catch(console.error);
