"use strict";
// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **
Object.defineProperty(exports, "__esModule", { value: true });
const gax = require("google-gax");
const path = require("path");
const gapicConfig = require("./firestore_admin_client_config.json");
const version = require('../../../package.json').version;
/**
 *  Operations are created by service `FirestoreAdmin`, but are accessed via
 *  service `google.longrunning.Operations`.
 * @class
 * @memberof v1
 */
class FirestoreAdminClient {
    /**
     * Construct an instance of FirestoreAdminClient.
     *
     * @param {object} [options] - The configuration object. See the subsequent
     *   parameters for more details.
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     */
    constructor(opts) {
        this._descriptors = {
            page: {},
            stream: {},
            longrunning: {},
            batching: {},
        };
        this._terminated = false;
        // Ensure that options include the service address and port.
        const staticMembers = this.constructor;
        const servicePath = opts && opts.servicePath
            ? opts.servicePath
            : opts && opts.apiEndpoint
                ? opts.apiEndpoint
                : staticMembers.servicePath;
        const port = opts && opts.port ? opts.port : staticMembers.port;
        if (!opts) {
            opts = { servicePath, port };
        }
        opts.servicePath = opts.servicePath || servicePath;
        opts.port = opts.port || port;
        opts.clientConfig = opts.clientConfig || {};
        const isBrowser = typeof window !== 'undefined';
        if (isBrowser) {
            opts.fallback = true;
        }
        // If we are in browser, we are already using fallback because of the
        // "browser" field in package.json.
        // But if we were explicitly requested to use fallback, let's do it now.
        this._gaxModule = !isBrowser && opts.fallback ? gax.fallback : gax;
        // Create a `gaxGrpc` object, with any grpc-specific options
        // sent to the client.
        opts.scopes = this.constructor.scopes;
        this._gaxGrpc = new this._gaxModule.GrpcClient(opts);
        // Save options to use in initialize() method.
        this._opts = opts;
        // Save the auth object to the client, for use by other methods.
        this.auth = this._gaxGrpc.auth;
        // Determine the client header string.
        const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
        if (typeof process !== 'undefined' && 'versions' in process) {
            clientHeader.push(`gl-node/${process.versions.node}`);
        }
        else {
            clientHeader.push(`gl-web/${this._gaxModule.version}`);
        }
        if (!opts.fallback) {
            clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
        }
        if (opts.libName && opts.libVersion) {
            clientHeader.push(`${opts.libName}/${opts.libVersion}`);
        }
        // Load the applicable protos.
        // For Node.js, pass the path to JSON proto file.
        // For browsers, pass the JSON content.
        const nodejsProtoPath = path.join(__dirname, '..', '..', 'protos', 'protos.json');
        this._protos = this._gaxGrpc.loadProto(opts.fallback ? require('../../protos/protos.json') : nodejsProtoPath);
        // This API contains "path templates"; forward-slash-separated
        // identifiers to uniquely identify resources within the API.
        // Create useful helper objects for these.
        this._pathTemplates = {
            collectionGroupPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection}'),
            databasePathTemplate: new this._gaxModule.PathTemplate('projects/{project}/databases/{database}'),
            fieldPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection}/fields/{field}'),
            indexPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection}/indexes/{index}'),
        };
        // Some of the methods on this service return "paged" results,
        // (e.g. 50 results at a time, with tokens to get subsequent
        // pages). Denote the keys used for pagination and results.
        this._descriptors.page = {
            listIndexes: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'indexes'),
            listFields: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'fields'),
        };
        // This API contains "long-running operations", which return a
        // an Operation object that allows for tracking of the operation,
        // rather than holding a request open.
        const protoFilesRoot = opts.fallback
            ? this._gaxModule.protobuf.Root.fromJSON(require('../../protos/protos.json'))
            : this._gaxModule.protobuf.loadSync(nodejsProtoPath);
        this.operationsClient = this._gaxModule
            .lro({
            auth: this.auth,
            grpc: 'grpc' in this._gaxGrpc ? this._gaxGrpc.grpc : undefined,
        })
            .operationsClient(opts);
        const createIndexResponse = protoFilesRoot.lookup('.google.firestore.admin.v1.Index');
        const createIndexMetadata = protoFilesRoot.lookup('.google.firestore.admin.v1.IndexOperationMetadata');
        const updateFieldResponse = protoFilesRoot.lookup('.google.firestore.admin.v1.Field');
        const updateFieldMetadata = protoFilesRoot.lookup('.google.firestore.admin.v1.FieldOperationMetadata');
        const exportDocumentsResponse = protoFilesRoot.lookup('.google.firestore.admin.v1.ExportDocumentsResponse');
        const exportDocumentsMetadata = protoFilesRoot.lookup('.google.firestore.admin.v1.ExportDocumentsMetadata');
        const importDocumentsResponse = protoFilesRoot.lookup('.google.protobuf.Empty');
        const importDocumentsMetadata = protoFilesRoot.lookup('.google.firestore.admin.v1.ImportDocumentsMetadata');
        this._descriptors.longrunning = {
            createIndex: new this._gaxModule.LongrunningDescriptor(this.operationsClient, createIndexResponse.decode.bind(createIndexResponse), createIndexMetadata.decode.bind(createIndexMetadata)),
            updateField: new this._gaxModule.LongrunningDescriptor(this.operationsClient, updateFieldResponse.decode.bind(updateFieldResponse), updateFieldMetadata.decode.bind(updateFieldMetadata)),
            exportDocuments: new this._gaxModule.LongrunningDescriptor(this.operationsClient, exportDocumentsResponse.decode.bind(exportDocumentsResponse), exportDocumentsMetadata.decode.bind(exportDocumentsMetadata)),
            importDocuments: new this._gaxModule.LongrunningDescriptor(this.operationsClient, importDocumentsResponse.decode.bind(importDocumentsResponse), importDocumentsMetadata.decode.bind(importDocumentsMetadata)),
        };
        // Put together the default options sent with requests.
        this._defaults = this._gaxGrpc.constructSettings('google.firestore.admin.v1.FirestoreAdmin', gapicConfig, opts.clientConfig || {}, { 'x-goog-api-client': clientHeader.join(' ') });
        // Set up a dictionary of "inner API calls"; the core implementation
        // of calling the API is handled in `google-gax`, with this code
        // merely providing the destination and request information.
        this._innerApiCalls = {};
    }
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize() {
        // If the client stub promise is already initialized, return immediately.
        if (this.firestoreAdminStub) {
            return this.firestoreAdminStub;
        }
        // Put together the "service stub" for
        // google.firestore.admin.v1.FirestoreAdmin.
        this.firestoreAdminStub = this._gaxGrpc.createStub(this._opts.fallback
            ? this._protos.lookupService('google.firestore.admin.v1.FirestoreAdmin')
            : // tslint:disable-next-line no-any
                this._protos.google.firestore.admin.v1.FirestoreAdmin, this._opts);
        // Iterate over each of the methods that the service provides
        // and create an API call method for each.
        const firestoreAdminStubMethods = [
            'createIndex',
            'listIndexes',
            'getIndex',
            'deleteIndex',
            'getField',
            'updateField',
            'listFields',
            'exportDocuments',
            'importDocuments',
        ];
        for (const methodName of firestoreAdminStubMethods) {
            const innerCallPromise = this.firestoreAdminStub.then(stub => (...args) => {
                if (this._terminated) {
                    return Promise.reject(new Error('The client has already been closed.'));
                }
                const func = stub[methodName];
                return func.apply(stub, args);
            }, (err) => () => {
                throw err;
            });
            const apiCall = this._gaxModule.createApiCall(innerCallPromise, this._defaults[methodName], this._descriptors.page[methodName] ||
                this._descriptors.stream[methodName] ||
                this._descriptors.longrunning[methodName]);
            this._innerApiCalls[methodName] = (argument, callOptions, callback) => {
                return apiCall(argument, callOptions, callback);
            };
        }
        return this.firestoreAdminStub;
    }
    /**
     * The DNS address for this API service.
     */
    static get servicePath() {
        return 'firestore.googleapis.com';
    }
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     */
    static get apiEndpoint() {
        return 'firestore.googleapis.com';
    }
    /**
     * The port for this API service.
     */
    static get port() {
        return 443;
    }
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     */
    static get scopes() {
        return [
            'https://www.googleapis.com/auth/cloud-platform',
            'https://www.googleapis.com/auth/datastore',
        ];
    }
    /**
     * Return the project ID used by this class.
     * @param {function(Error, string)} callback - the callback to
     *   be called with the current project Id.
     */
    getProjectId(callback) {
        if (callback) {
            this.auth.getProjectId(callback);
            return;
        }
        return this.auth.getProjectId();
    }
    /**
     * Gets a composite index.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. A name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Index]{@link google.firestore.admin.v1.Index}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    getIndex(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.getIndex(request, options, callback);
    }
    /**
     * Deletes a composite index.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. A name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    deleteIndex(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.deleteIndex(request, options, callback);
    }
    /**
     * Gets the metadata and configuration for a Field.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. A name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_id}`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Field]{@link google.firestore.admin.v1.Field}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    getField(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.getField(request, options, callback);
    }
    /**
     * Creates a composite index. This returns a {@link google.longrunning.Operation|google.longrunning.Operation}
     * which may be used to track the status of the creation. The metadata for
     * the operation will be the type {@link google.firestore.admin.v1.IndexOperationMetadata|IndexOperationMetadata}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. A parent name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param {google.firestore.admin.v1.Index} request.index
     *   Required. The composite index to create.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Operation]{@link google.longrunning.Operation}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    createIndex(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.createIndex(request, options, callback);
    }
    /**
     * Updates a field configuration. Currently, field updates apply only to
     * single field index configuration. However, calls to
     * {@link google.firestore.admin.v1.FirestoreAdmin.UpdateField|FirestoreAdmin.UpdateField} should provide a field mask to avoid
     * changing any configuration that the caller isn't aware of. The field mask
     * should be specified as: `{ paths: "index_config" }`.
     *
     * This call returns a {@link google.longrunning.Operation|google.longrunning.Operation} which may be used to
     * track the status of the field update. The metadata for
     * the operation will be the type {@link google.firestore.admin.v1.FieldOperationMetadata|FieldOperationMetadata}.
     *
     * To configure the default field settings for the database, use
     * the special `Field` with resource name:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {google.firestore.admin.v1.Field} request.field
     *   Required. The field to be updated.
     * @param {google.protobuf.FieldMask} request.updateMask
     *   A mask, relative to the field. If specified, only configuration specified
     *   by this field_mask will be updated in the field.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Operation]{@link google.longrunning.Operation}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    updateField(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            'field.name': request.field.name || '',
        });
        this.initialize();
        return this._innerApiCalls.updateField(request, options, callback);
    }
    /**
     * Exports a copy of all or a subset of documents from Google Cloud Firestore
     * to another storage system, such as Google Cloud Storage. Recent updates to
     * documents may not be reflected in the export. The export occurs in the
     * background and its progress can be monitored and managed via the
     * Operation resource that is created. The output of an export may only be
     * used once the associated operation is done. If an export operation is
     * cancelled before completion it may leave partial data behind in Google
     * Cloud Storage.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. Database to export. Should be of the form:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {string[]} request.collectionIds
     *   Which collection ids to export. Unspecified means all collections.
     * @param {string} request.outputUriPrefix
     *   The output URI. Currently only supports Google Cloud Storage URIs of the
     *   form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     *   of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     *   Google Cloud Storage namespace path. When
     *   choosing a name, be sure to consider Google Cloud Storage naming
     *   guidelines: https://cloud.google.com/storage/docs/naming.
     *   If the URI is a bucket (without a namespace path), a prefix will be
     *   generated based on the start time.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Operation]{@link google.longrunning.Operation}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    exportDocuments(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.exportDocuments(request, options, callback);
    }
    /**
     * Imports documents into Google Cloud Firestore. Existing documents with the
     * same name are overwritten. The import occurs in the background and its
     * progress can be monitored and managed via the Operation resource that is
     * created. If an ImportDocuments operation is cancelled, it is possible
     * that a subset of the data has already been imported to Cloud Firestore.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. Database to import into. Should be of the form:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {string[]} request.collectionIds
     *   Which collection ids to import. Unspecified means all collections included
     *   in the import.
     * @param {string} request.inputUriPrefix
     *   Location of the exported files.
     *   This must match the output_uri_prefix of an ExportDocumentsResponse from
     *   an export that has completed successfully.
     *   See:
     *   {@link google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix|google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Operation]{@link google.longrunning.Operation}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    importDocuments(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.importDocuments(request, options, callback);
    }
    /**
     * Lists composite indexes.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. A parent name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param {string} request.filter
     *   The filter to apply to list results.
     * @param {number} request.pageSize
     *   The number of results to return.
     * @param {string} request.pageToken
     *   A page token, returned from a previous call to
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListIndexes|FirestoreAdmin.ListIndexes}, that may be used to get the next
     *   page of results.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [Index]{@link google.firestore.admin.v1.Index}.
     *   The client library support auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *
     *   When autoPaginate: false is specified through options, the array has three elements.
     *   The first element is Array of [Index]{@link google.firestore.admin.v1.Index} that corresponds to
     *   the one page received from the API server.
     *   If the second element is not null it contains the request object of type [ListIndexesRequest]{@link google.firestore.admin.v1.ListIndexesRequest}
     *   that can be used to obtain the next page of the results.
     *   If it is null, the next page does not exist.
     *   The third element contains the raw response received from the API server. Its type is
     *   [ListIndexesResponse]{@link google.firestore.admin.v1.ListIndexesResponse}.
     *
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    listIndexes(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.listIndexes(request, options, callback);
    }
    /**
     * Equivalent to {@link listIndexes}, but returns a NodeJS Stream object.
     *
     * This fetches the paged responses for {@link listIndexes} continuously
     * and invokes the callback registered for 'data' event for each element in the
     * responses.
     *
     * The returned object has 'end' method when no more elements are required.
     *
     * autoPaginate option will be ignored.
     *
     * @see {@link https://nodejs.org/api/stream.html}
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. A parent name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param {string} request.filter
     *   The filter to apply to list results.
     * @param {number} request.pageSize
     *   The number of results to return.
     * @param {string} request.pageToken
     *   A page token, returned from a previous call to
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListIndexes|FirestoreAdmin.ListIndexes}, that may be used to get the next
     *   page of results.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [Index]{@link google.firestore.admin.v1.Index} on 'data' event.
     */
    listIndexesStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this._descriptors.page.listIndexes.createStream(this._innerApiCalls.listIndexes, request, callSettings);
    }
    /**
     * Lists the field configuration and metadata for this database.
     *
     * Currently, {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields} only supports listing fields
     * that have been explicitly overridden. To issue this query, call
     * {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields} with the filter set to
     * `indexConfig.usesAncestorConfig:false`.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. A parent name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param {string} request.filter
     *   The filter to apply to list results. Currently,
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields} only supports listing fields
     *   that have been explicitly overridden. To issue this query, call
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields} with the filter set to
     *   `indexConfig.usesAncestorConfig:false`.
     * @param {number} request.pageSize
     *   The number of results to return.
     * @param {string} request.pageToken
     *   A page token, returned from a previous call to
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields}, that may be used to get the next
     *   page of results.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [Field]{@link google.firestore.admin.v1.Field}.
     *   The client library support auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *
     *   When autoPaginate: false is specified through options, the array has three elements.
     *   The first element is Array of [Field]{@link google.firestore.admin.v1.Field} that corresponds to
     *   the one page received from the API server.
     *   If the second element is not null it contains the request object of type [ListFieldsRequest]{@link google.firestore.admin.v1.ListFieldsRequest}
     *   that can be used to obtain the next page of the results.
     *   If it is null, the next page does not exist.
     *   The third element contains the raw response received from the API server. Its type is
     *   [ListFieldsResponse]{@link google.firestore.admin.v1.ListFieldsResponse}.
     *
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    listFields(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.listFields(request, options, callback);
    }
    /**
     * Equivalent to {@link listFields}, but returns a NodeJS Stream object.
     *
     * This fetches the paged responses for {@link listFields} continuously
     * and invokes the callback registered for 'data' event for each element in the
     * responses.
     *
     * The returned object has 'end' method when no more elements are required.
     *
     * autoPaginate option will be ignored.
     *
     * @see {@link https://nodejs.org/api/stream.html}
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. A parent name of the form
     *   `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param {string} request.filter
     *   The filter to apply to list results. Currently,
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields} only supports listing fields
     *   that have been explicitly overridden. To issue this query, call
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields} with the filter set to
     *   `indexConfig.usesAncestorConfig:false`.
     * @param {number} request.pageSize
     *   The number of results to return.
     * @param {string} request.pageToken
     *   A page token, returned from a previous call to
     *   {@link google.firestore.admin.v1.FirestoreAdmin.ListFields|FirestoreAdmin.ListFields}, that may be used to get the next
     *   page of results.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [Field]{@link google.firestore.admin.v1.Field} on 'data' event.
     */
    listFieldsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this._descriptors.page.listFields.createStream(this._innerApiCalls.listFields, request, callSettings);
    }
    // --------------------
    // -- Path templates --
    // --------------------
    /**
     * Return a fully-qualified collectionGroup resource name string.
     *
     * @param {string} project
     * @param {string} database
     * @param {string} collection
     * @returns {string} Resource name string.
     */
    collectionGroupPath(project, database, collection) {
        return this._pathTemplates.collectionGroupPathTemplate.render({
            project,
            database,
            collection,
        });
    }
    /**
     * Parse the project from CollectionGroup resource.
     *
     * @param {string} collectionGroupName
     *   A fully-qualified path representing CollectionGroup resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromCollectionGroupName(collectionGroupName) {
        return this._pathTemplates.collectionGroupPathTemplate.match(collectionGroupName).project;
    }
    /**
     * Parse the database from CollectionGroup resource.
     *
     * @param {string} collectionGroupName
     *   A fully-qualified path representing CollectionGroup resource.
     * @returns {string} A string representing the database.
     */
    matchDatabaseFromCollectionGroupName(collectionGroupName) {
        return this._pathTemplates.collectionGroupPathTemplate.match(collectionGroupName).database;
    }
    /**
     * Parse the collection from CollectionGroup resource.
     *
     * @param {string} collectionGroupName
     *   A fully-qualified path representing CollectionGroup resource.
     * @returns {string} A string representing the collection.
     */
    matchCollectionFromCollectionGroupName(collectionGroupName) {
        return this._pathTemplates.collectionGroupPathTemplate.match(collectionGroupName).collection;
    }
    /**
     * Return a fully-qualified database resource name string.
     *
     * @param {string} project
     * @param {string} database
     * @returns {string} Resource name string.
     */
    databasePath(project, database) {
        return this._pathTemplates.databasePathTemplate.render({
            project,
            database,
        });
    }
    /**
     * Parse the project from Database resource.
     *
     * @param {string} databaseName
     *   A fully-qualified path representing Database resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromDatabaseName(databaseName) {
        return this._pathTemplates.databasePathTemplate.match(databaseName).project;
    }
    /**
     * Parse the database from Database resource.
     *
     * @param {string} databaseName
     *   A fully-qualified path representing Database resource.
     * @returns {string} A string representing the database.
     */
    matchDatabaseFromDatabaseName(databaseName) {
        return this._pathTemplates.databasePathTemplate.match(databaseName)
            .database;
    }
    /**
     * Return a fully-qualified field resource name string.
     *
     * @param {string} project
     * @param {string} database
     * @param {string} collection
     * @param {string} field
     * @returns {string} Resource name string.
     */
    fieldPath(project, database, collection, field) {
        return this._pathTemplates.fieldPathTemplate.render({
            project,
            database,
            collection,
            field,
        });
    }
    /**
     * Parse the project from Field resource.
     *
     * @param {string} fieldName
     *   A fully-qualified path representing Field resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromFieldName(fieldName) {
        return this._pathTemplates.fieldPathTemplate.match(fieldName).project;
    }
    /**
     * Parse the database from Field resource.
     *
     * @param {string} fieldName
     *   A fully-qualified path representing Field resource.
     * @returns {string} A string representing the database.
     */
    matchDatabaseFromFieldName(fieldName) {
        return this._pathTemplates.fieldPathTemplate.match(fieldName).database;
    }
    /**
     * Parse the collection from Field resource.
     *
     * @param {string} fieldName
     *   A fully-qualified path representing Field resource.
     * @returns {string} A string representing the collection.
     */
    matchCollectionFromFieldName(fieldName) {
        return this._pathTemplates.fieldPathTemplate.match(fieldName).collection;
    }
    /**
     * Parse the field from Field resource.
     *
     * @param {string} fieldName
     *   A fully-qualified path representing Field resource.
     * @returns {string} A string representing the field.
     */
    matchFieldFromFieldName(fieldName) {
        return this._pathTemplates.fieldPathTemplate.match(fieldName).field;
    }
    /**
     * Return a fully-qualified index resource name string.
     *
     * @param {string} project
     * @param {string} database
     * @param {string} collection
     * @param {string} index
     * @returns {string} Resource name string.
     */
    indexPath(project, database, collection, index) {
        return this._pathTemplates.indexPathTemplate.render({
            project,
            database,
            collection,
            index,
        });
    }
    /**
     * Parse the project from Index resource.
     *
     * @param {string} indexName
     *   A fully-qualified path representing Index resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromIndexName(indexName) {
        return this._pathTemplates.indexPathTemplate.match(indexName).project;
    }
    /**
     * Parse the database from Index resource.
     *
     * @param {string} indexName
     *   A fully-qualified path representing Index resource.
     * @returns {string} A string representing the database.
     */
    matchDatabaseFromIndexName(indexName) {
        return this._pathTemplates.indexPathTemplate.match(indexName).database;
    }
    /**
     * Parse the collection from Index resource.
     *
     * @param {string} indexName
     *   A fully-qualified path representing Index resource.
     * @returns {string} A string representing the collection.
     */
    matchCollectionFromIndexName(indexName) {
        return this._pathTemplates.indexPathTemplate.match(indexName).collection;
    }
    /**
     * Parse the index from Index resource.
     *
     * @param {string} indexName
     *   A fully-qualified path representing Index resource.
     * @returns {string} A string representing the index.
     */
    matchIndexFromIndexName(indexName) {
        return this._pathTemplates.indexPathTemplate.match(indexName).index;
    }
    /**
     * Terminate the GRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     */
    close() {
        this.initialize();
        if (!this._terminated) {
            return this.firestoreAdminStub.then(stub => {
                this._terminated = true;
                stub.close();
            });
        }
        return Promise.resolve();
    }
}
exports.FirestoreAdminClient = FirestoreAdminClient;
//# sourceMappingURL=firestore_admin_client.js.map