import { Router } from "express";
import DeferralController from "../../controller/deferralController";
import { verifyToken } from "../../middleware/verifyToken";

export default class DeferralRouter {
    readonly router: Router = Router();
    readonly controller: DeferralController = new DeferralController();
    
    constructor() {
        this.initRoutes();
    }

    initRoutes() {
        this.router.use(verifyToken);
        this.router.post('/', this.controller.create);
        this.router.get('/', this.controller.getAll);
        this.router.put('/:id', this.controller.update);
        this.router.delete('/:id', this.controller.delete);
        this.router.get('/history/:id', this.controller.getHistoryByDeferralId);
        this.router.get('/history/by-type-no/:typeNo', this.controller.getHistoryByTypeNo);
    }
}