import { Router } from "express";
import FluidsController from "../../controller/fluidsController";
import { verifyToken } from "../../middleware/verifyToken";

export default class FluidsRouter {
  router: Router;

  constructor() {
    this.router = Router();
    this.routes();
  }

  routes() {
    this.router.use(verifyToken);
    const fluidsController = new FluidsController();
    
    // Save fluids data
    this.router.post('/:logId/fluids', fluidsController.saveFluids);
    
    // Get fluids data
    this.router.get('/:logId/fluids', fluidsController.getFluids);
  }
}