import { Router } from "express";
import userRouter from "./userRoutes/user.routes";
import AircraftRouter from "./aircraftRoutes/aircraft.routes";
import DeviceRouter from "./deviceRoutes/device.routes";
import FlightRouter from "./flightRoutes/flight.routes";
import DocumentRouter from "./documentRoutes/document.routes";
import NoticeRouter from "./noticeRoutes/notice.routes";
import LogRouter from "./logsRoutes/logs.routes";
import DeferralRouter from "./deferralRoutes/deferral.routes";
import DamageRouter from "./damageRoutes/damage.routes";
import CheckRouter from "./checkRoutes/check.routes";
import FluidsRouter from "./fluidsRoutes/fluids.routes"; // Add this import

export default class Routes {
  router: Router;
  
  constructor() {
    this.router = Router();
    this.routes();
  }
  
  routes() {
    this.router.use('/user', new userRouter().router);
    this.router.use('/aircrafts', new AircraftRouter().router);
    this.router.use('/devices', new DeviceRouter().router);
    this.router.use('/flights', new FlightRouter().router);
    this.router.use('/documents', new DocumentRouter().router);
    this.router.use('/notices', new NoticeRouter().router);
    this.router.use('/logs', new LogRouter().router);
    this.router.use('/deferrals', new DeferralRouter().router);
    this.router.use('/damages', new DamageRouter().router);
    this.router.use('/checks', new CheckRouter().router);
    this.router.use('/fluids', new FluidsRouter().router); // Add this line
  }
}