'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('property_items', {
      id: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
      },
      property_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: true,
      },
      included_excluded_status: {
        type: Sequelize.INTEGER,
        defaultValue: 0,
      },
      name: {
        type: Sequelize.STRING(1000),
        allowNull: true,
      },
      amount: {
        type: Sequelize.DOUBLE(15, 2),
        allowNull: true,
      },
      item_number: {
        type: Sequelize.STRING(250),
        allowNull: true,
      },
      item_type: {
        type: Sequelize.STRING(250),
        allowNull: true,
      },
      appliance_brand: {
        type: Sequelize.STRING(250),
        allowNull: true,
      },
      appliance_model: {
        type: Sequelize.STRING(250),
        allowNull: true,
      },
      warranty_start_date: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      warranty_end_date: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      appliance_description: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      utility_provider_name: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      utility_description: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      other_description: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      created_at: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('property_items');
  },
};
