'use strict';
module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('recurring_invoices', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      tenant_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
      },
      issue_date: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      frequency: {
        type: Sequelize.STRING(100),
        allowNull: false,
      },
      next_date: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      due_date: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      note: {
        type: Sequelize.TEXT('long'),
        allowNull: true,
      },
      subtotal: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      discount_type: {
        type: Sequelize.STRING(10),
        allowNull: true,
      },
      discount: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      total: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      send_email: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      print_invoice: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      print_fax: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: true
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: true
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('recurring_invoices');
  }
};
