'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('checks', {
      id: { type: Sequelize.BIGINT.UNSIGNED, autoIncrement: true, primaryKey: true },
      vendor_id: { type: Sequelize.STRING(50), allowNull: false },
      bank_id: { type: Sequelize.INTEGER, allowNull: true },
      available_balance: { type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0 },
      street: { type: Sequelize.STRING(255), allowNull: true },
      suit: { type: Sequelize.STRING(100), allowNull: true },
      zip: { type: Sequelize.STRING(20), allowNull: true },
      city: { type: Sequelize.STRING(100), allowNull: true },
      state: { type: Sequelize.STRING(100), allowNull: true },
      check_no: { type: Sequelize.STRING(50), allowNull: false },
      total_amount: { type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0 },
      payment_date: { type: Sequelize.STRING(50), allowNull: true },
      invoice_number: { type: Sequelize.STRING(50), allowNull: true },
      remaining_balance: { type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0 },
      send_email: { type: Sequelize.BOOLEAN, defaultValue: false },
      print_check: { type: Sequelize.BOOLEAN, defaultValue: false },
      unit_id: { type: Sequelize.INTEGER, allowNull: true },
      created_by: { type: Sequelize.INTEGER.UNSIGNED, allowNull: false },
      created_at: { allowNull: false, type: Sequelize.DATE, defaultValue: Sequelize.literal('CURRENT_TIMESTAMP') },
      updated_at: { allowNull: false, type: Sequelize.DATE, defaultValue: Sequelize.literal('CURRENT_TIMESTAMP') }
    });
  },

  down: async (queryInterface) => {
    await queryInterface.dropTable('checks');
  }
};
