/* jshint indent: 2 */

module.exports = function(sequelize, DataTypes) {
  const employee = sequelize.define('employee_change', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    unit_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    employee_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    type: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    emp_type: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    change_title: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    change_desc: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    deletedAt: {
      field: 'deleted_at',
      type: 'TIMESTAMP',
      allowNull: true
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'employee_changes'
  });

  employee.associate = function (models) {
    models.sale.belongsTo(models.unit, { foreignKey: 'unit_id', targetKey: 'id' })
  }

  return employee;
};
