module.exports = function (sequelize, DataTypes) {
  const EmployeeShift = sequelize.define(
    'employee_shift',
    {
      id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
      },
      unit_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
      },
      shift_name: {
        type: DataTypes.STRING(191),
        allowNull: false,
      },
      shift_short_code: {
        type: DataTypes.STRING(191),
        allowNull: false,
      },
      shift_type: {
        type: DataTypes.ENUM('strict', 'flexible'),
        allowNull: false,
      },
      flexible_total_hours: {
        type: DataTypes.DOUBLE,
        allowNull: true,
      },
      flexible_half_day_hours: {
        type: DataTypes.DOUBLE,
        allowNull: true,
      },
      color: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      is_default: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
      },
      office_start_time: {
        type: DataTypes.TIME,
        allowNull: true,
      },
      office_end_time: {
        type: DataTypes.TIME,
        allowNull: true,
      },
      halfday_mark_time: {
        type: DataTypes.TIME,
        allowNull: true,
      },
      late_mark_duration: {
        type: DataTypes.INTEGER, 
        allowNull: true,
        defaultValue: 0,
      },
      early_clock_in: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0,
      },
      clockin_in_day: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0,
      },
      office_open_days: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      created_by: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: true,
      },
      createdAt: {
        field: 'created_at',
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
      },
      updatedAt: {
        field: 'updated_at',
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      timestamps: true,
      underscored: true,
      freezeTableName: true,
      tableName: 'employee_shifts',
    }
  );

  EmployeeShift.associate = (models) => {
    // Optional associations (e.g., if unit is another model)
    // EmployeeShift.belongsTo(models.unit, {
    //   foreignKey: 'unit_id',
    //   as: 'unit'
    // });
  };

  return EmployeeShift;
};
