/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const Property = sequelize.define('property', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: { 
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    parent_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    franchise_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
      comment: 'Franchise this property belongs to',
    },
    ownership_type: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    name: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    property_type: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    size: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    street_number: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    suite_floor: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    zip_code: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    country: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    borough: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    block: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    lot: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    parking_type: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    number_of_bedrooms: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    number_of_kitchens: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    number_of_bathrooms: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    rent_price: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    market_rent: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    deposit_amount: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    notes: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    main_image: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    additional_images: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    created_at: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updated_at: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'property',
  });

  Property.associate = (models) => {

    Property.hasMany(models.owner, {
      foreignKey: 'property_id',
      as: 'owners',
    });
  };

  return Property;
};
