'use strict';
module.exports = function (sequelize, DataTypes) {
  const PropertyTax = sequelize.define('property_tax', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    property_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    tax_type: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    frequency: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    amount: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    next_payment_due_date: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    reminder_before_due: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    status: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    vendor_id: {
      type: DataTypes.STRING(55),
      allowNull: true,
    },
    payment_method: {
      type: DataTypes.STRING(55),
      allowNull: true,
    },
    payment_detail: {
      type: DataTypes.STRING(550),
      allowNull: true,
    },
    payment_date: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    payment_ref: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      defaultValue: null,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'property_taxes',
  });

  return PropertyTax;
};
