module.exports = function (sequelize, DataTypes) {
  const RecurringInvoiceItem = sequelize.define('recurring_invoice_items', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    recurring_invoice_id: {
      type: DataTypes.BIGINT.UNSIGNED, // ✅ fixed this
      allowNull: false,
      references: {
        model: 'recurring_invoices',
        key: 'id',
      },
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    },
    code: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(1000),
      allowNull: false,
    },
    amount: {
      type: DataTypes.DOUBLE(15, 2),
      allowNull: false,
      defaultValue: 0.00,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'recurring_invoice_items',
  });

  RecurringInvoiceItem.associate = function (models) {
    RecurringInvoiceItem.belongsTo(models.recurring_invoices, {
      foreignKey: 'recurring_invoice_id',
      as: 'recurring_invoice'
    });
  };

  return RecurringInvoiceItem;
};
