module.exports = function (sequelize, DataTypes) {
  const TaskHistory = sequelize.define('task_history', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    task_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    sub_task_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    user_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    details: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true, 
    freezeTableName: true,
    tableName: 'task_history',
  });

  TaskHistory.associate = function(models) {
    TaskHistory.belongsTo(models.tasks, {
      foreignKey: 'task_id',
      as: 'task',
      onDelete: 'CASCADE',
    });
    TaskHistory.belongsTo(models.user, {
      foreignKey: 'user_id',
      as: 'user',
    });
  };

  return TaskHistory;
};