module.exports = function (sequelize, DataTypes) {
  const TenantInvoice = sequelize.define('tenant_invoices', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    }, 
    tenant_id: {
      type: DataTypes.BIGINT.UNSIGNED,  
      allowNull: false,
      references: {
        model: 'tenants',
        key: 'id',
      },
    },
    invoice_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'invoices',
        key: 'id',
      },
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'tenant_invoices',
  });

  TenantInvoice.associate = function (models) {
    TenantInvoice.belongsTo(models.invoices, {
      foreignKey: 'invoice_id',
      as: 'invoice',
    });
    
    TenantInvoice.belongsTo(models.tenants, {
      foreignKey: 'tenant_id',
      as: 'tenant',
    });
  };
  
  return TenantInvoice;
};