module.exports = (sequelize, DataTypes) => {
  const TenantRevenueReceived = sequelize.define(
    'tenant_revenue_received',
    {
      id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true, 
      },
      tenant_id: {  
        type: DataTypes.BIGINT.UNSIGNED, 
        allowNull: false,
      },
      revenue_id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
      },
      created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
      },
      updated_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      tableName: 'tenant_revenue_received',
      timestamps: false,
    }
  );

  TenantRevenueReceived.associate = (models) => {
    TenantRevenueReceived.belongsTo(models.tenants, {
      foreignKey: 'tenant_id',
      as: 'tenant',
    });

    TenantRevenueReceived.belongsTo(models.revenue_received, {
      foreignKey: 'revenue_id',
      as: 'revenue',
    });
  };

  return TenantRevenueReceived;
};
