module.exports = function(sequelize, DataTypes) {
  const user_activity = sequelize.define('user_activity', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    }, 
    activity_type: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    activity_time: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW
    },
    details: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    status: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    ip_address: {
      type: DataTypes.STRING(45),
      allowNull: true
    },
    user_agent: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    unit_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    source: {
      type: DataTypes.STRING(20),
      allowNull: true
    }
  }, {
    timestamps: false,
    underscored: true,
    freezeTableName: true,
    tableName: 'user_activity'
  });

  user_activity.associate = function(models) {
    user_activity.belongsTo(models.user, { foreignKey: 'user_id', targetKey: 'id' });
  };

  return user_activity;
};
