// models/user_employee_map.js
/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const UserEmployeeMap = sequelize.define('user_employee_map', {
      id: {
        type: DataTypes.INTEGER(11),
        primaryKey: true,
        autoIncrement: true
      },
      user_id: { 
        type: DataTypes.INTEGER(11),
        allowNull: false
      },
      employee_id: {
        type: DataTypes.INTEGER(11),
        allowNull: false
      },
      createdAt: {
        field: 'created_at',
        type: DataTypes.DATE,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
      },
      updatedAt: {
        field: 'updated_at',
        type: DataTypes.DATE,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
      }
    },
    {
      tableName: 'user_employee_map',
      timestamps: true,
      underscored: true,
      freezeTableName: true
    }
  );

  UserEmployeeMap.associate = function (models) {
    // User ↔ Employee mapping
    UserEmployeeMap.belongsTo(models.user, {
      foreignKey: 'user_id',
      as: 'user'
    });

    UserEmployeeMap.belongsTo(models.employee, {
      foreignKey: 'employee_id',
      as: 'employee'
    });
  };

  return UserEmployeeMap;
};
