"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
var _Object$getOwnPropertyDescriptor = require("@babel/runtime-corejs3/core-js-stable/object/get-own-property-descriptor");
var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");
var _WeakMap = require("@babel/runtime-corejs3/core-js-stable/weak-map");
_Object$defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResolverJSON;
var _forEach = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/for-each"));
var _create = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/object/create"));
var _values = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/values"));
var _map = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/map"));
var _ducky = _interopRequireDefault(require("ducky"));
var GraphQL = _interopRequireWildcard(require("graphql"));
var GraphQLLanguage = _interopRequireWildcard(require("graphql/language"));
var _error = require("graphql/error");
function _getRequireWildcardCache(nodeInterop) { if (typeof _WeakMap !== "function") return null; var cacheBabelInterop = new _WeakMap(); var cacheNodeInterop = new _WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = _Object$defineProperty && _Object$getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? _Object$getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { _Object$defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
**  GraphQL-Tools-Types -- Custom Scalar Types for GraphQL-Tools
**  Copyright (c) 2016-2021 Dr. Ralf S. Engelschall <rse@engelschall.com>
**
**  Permission is hereby granted, free of charge, to any person obtaining
**  a copy of this software and associated documentation files (the
**  "Software"), to deal in the Software without restriction, including
**  without limitation the rights to use, copy, modify, merge, publish,
**  distribute, sublicense, and/or sell copies of the Software, and to
**  permit persons to whom the Software is furnished to do so, subject to
**  the following conditions:
**
**  The above copyright notice and this permission notice shall be included
**  in all copies or substantial portions of the Software.
**
**  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
**  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
**  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
**  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
**  CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
**  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
**  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

/*  external requirements  */

/*  JSON resolver for GraphQL Tools  */
function ResolverJSON(options = {}) {
  const errors = [];
  if (!_ducky.default.validate(options, "{ name: string, struct?: string }", errors)) throw new _error.GraphQLError("[graphql-tools-types] " + `invalid parameters: ${errors.join("; ")}`, []);
  return {
    /*  serialize value sent as output to the client  */
    __serialize: value => {
      /*  no-op as JSON is native output format  */
      return value;
    },
    /*  parse value received as input from client  */
    __parseValue: value => {
      /*  no-op (except for structure validation) as JSON is native input format  */
      if (options.struct !== undefined) {
        const errors = [];
        if (!_ducky.default.validate(value, options.struct, errors)) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + `unexpected JSON structure: ${errors.join("; ")}`, []);
      }
      return value;
    },
    /*  parse value received as literal in AST  */
    __parseLiteral: (ast, variables) => {
      let result;
      try {
        const parseJSONLiteral = ast => {
          var _context;
          switch (ast.kind) {
            case GraphQLLanguage.Kind.BOOLEAN:
              return GraphQL.GraphQLBoolean.parseLiteral(ast, variables);
            case GraphQLLanguage.Kind.INT:
              return GraphQL.GraphQLInt.parseLiteral(ast, variables);
            case GraphQLLanguage.Kind.STRING:
              return GraphQL.GraphQLString.parseLiteral(ast, variables);
            case GraphQLLanguage.Kind.FLOAT:
              return GraphQL.GraphQLFloat.parseLiteral(ast, variables);
            case GraphQLLanguage.Kind.ENUM:
              return String(ast.value);
            case GraphQLLanguage.Kind.VARIABLE:
              return variables ? variables[ast.name.value] : "";
            case GraphQLLanguage.Kind.LIST:
              return (0, _map.default)(_context = (0, _values.default)(ast)).call(_context, astItem => {
                return parseJSONLiteral(astItem); /* RECURSION */
              });

            case GraphQLLanguage.Kind.OBJECT:
              {
                var _context2;
                const value = (0, _create.default)(null);
                (0, _forEach.default)(_context2 = ast.fields).call(_context2, field => {
                  value[field.name.value] = parseJSONLiteral(field.value); /* RECURSION */
                });

                return value;
              }
            default:
              return null;
          }
        };
        result = parseJSONLiteral(ast);
      } catch (ex) {
        throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + `error parsing JSON: ${ex.toString()}`, [ast]);
      }
      if (options.struct !== undefined) {
        const errors = [];
        if (!_ducky.default.validate(result, options.struct, errors)) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + `unexpected JSON structure: ${errors.join("; ")}`, []);
      }
      return result;
    }
  };
}
