'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('invoices', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      tenant_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
      },
      invoice_no: {
        type: Sequelize.STRING(100),
        allowNull: false,
        unique: true
      },
      issue_date: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      due_date: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      note: {
        type: Sequelize.TEXT('long'),
        allowNull: true,
      },
      subtotal: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      discount_type: {
        type: Sequelize.STRING(10),
        allowNull: true,
      },
      discount: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      total: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      balance: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      paid_amount: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      status: {
        type: Sequelize.ENUM('paid', 'unpaid', 'partial'),
        allowNull: false,
        defaultValue: 'unpaid'
      },
      send_email: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      print_invoice: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      print_fax: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: true
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: true
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('invoices');
    await queryInterface.sequelize.query('DROP TYPE IF EXISTS "enum_invoices_status";');
  }
};
