"use strict";

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable("vendor_payments", {
      id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      vendor_id: {
        type: Sequelize.INTEGER,
        allowNull: false,
      },
      account_no: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      select_bank: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      credit_limit: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      billing_rate: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      print_name: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      print_sign: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      created_by: {
        type: Sequelize.INTEGER,
        allowNull: false,
      },
      updated_by: {
        type: Sequelize.INTEGER,
        allowNull: true,
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.fn("NOW"),
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.fn("NOW"),
      },
    });
  },

  down: async (queryInterface) => {
    await queryInterface.dropTable("vendor_payments");
  },
};
