/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const ClientDocument = sequelize.define('client_document', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    client_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: false,
    },
    file_archive_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'client_documents',
  });

  ClientDocument.associate = function (models) {
    ClientDocument.belongsTo(models.file_archive, { 
      foreignKey: 'file_archive_id',
      as: 'file_archive',
    });
  }

  return ClientDocument;
};