/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const GlobalCurrency = sequelize.define('global_currency', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: { 
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true
    },
    currency_name: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    currency_symbol: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    currency_code: { 
      type: DataTypes.STRING(191),
      allowNull: false,
    }, 
    is_cryptocurrency: {
      type: DataTypes.STRING(20),
      allowNull: false,
    }, 
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true, 
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'global_currency',
  });

  // 🔗 Define reverse association
  GlobalCurrency.associate = function(models) {
    GlobalCurrency.hasMany(models.package, {
      foreignKey: 'currency_id',
      as: 'packages'
    });
  };

  return GlobalCurrency;
};
