module.exports = function (sequelize, DataTypes) {
  const LeaveType = sequelize.define('leave_type', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
     
    name: {
      type: DataTypes.STRING(100),
      allowNull: false,
    },

    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },

    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },

    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },

    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },

  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'leave_type',
  });

  return LeaveType;
};
