module.exports = function (sequelize, DataTypes) {
  const Contact = sequelize.define('tenant_contacts',
    {
      id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      is_name_show: {
        type: DataTypes.BOOLEAN,
        defaultValue: false
      },
      tenant_id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: true
      },
      first_name: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      last_name: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      ssn: {
        type: DataTypes.STRING(50),
        allowNull: true
      },
      phone: {
        type: DataTypes.STRING(100),
        allowNull: true
      },
      email: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      id_type: {
        type: DataTypes.STRING(100),
        allowNull: true
      },
      id_number: {
        type: DataTypes.STRING(100),
        allowNull: true
      },
      gender: {
        type: DataTypes.STRING(50),
        allowNull: true
      },
      date_of_birth: {
        type: DataTypes.STRING(20), // or DataTypes.DATE if needed
        allowNull: true
      },
      monthly_gross_income: {
        type: DataTypes.DECIMAL(15, 2),
        allowNull: true
      },
      additional_income: {
        type: DataTypes.DECIMAL(15, 2),
        allowNull: true
      },
      marital_status: {
        type: DataTypes.STRING(100),
        allowNull: true
      },
      ethnicity: {
        type: DataTypes.STRING(100),
        allowNull: true
      },
      createdAt: {
        field: 'created_at',
        type: DataTypes.DATE
      },
      updatedAt: {
        field: 'updated_at',
        type: DataTypes.DATE
      },
    },
    {
      timestamps: true,
      underscored: true,
      freezeTableName: true,
      tableName: 'tenant_contacts',
    }
  );
  return Contact;
};