"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Content
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentPage = exports.ContentInstance = exports.ContentContextImpl = exports.WhatsappFlows = exports.WhatsappCard = exports.WhatsappAuthentication = exports.Types = exports.TwilioText = exports.TwilioSchedule = exports.TwilioQuickReply = exports.TwilioMedia = exports.TwilioLocation = exports.TwilioListPicker = exports.TwilioFlows = exports.TwilioCatalog = exports.TwilioCarousel = exports.TwilioCard = exports.TwilioCallToAction = exports.QuickReplyAction = exports.ListItem = exports.FlowsPageComponent = exports.FlowsPage = exports.ContentUpdateRequest = exports.ContentCreateRequest = exports.CatalogItem = exports.CarouselCard = exports.CarouselAction = exports.CardAction = exports.CallToActionAction = exports.AuthenticationAction = void 0;
exports.ContentListInstance = ContentListInstance;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../base/Page"));
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
const approvalCreate_1 = require("./content/approvalCreate");
const approvalFetch_1 = require("./content/approvalFetch");
class AuthenticationAction {
}
exports.AuthenticationAction = AuthenticationAction;
class CallToActionAction {
}
exports.CallToActionAction = CallToActionAction;
class CardAction {
}
exports.CardAction = CardAction;
class CarouselAction {
}
exports.CarouselAction = CarouselAction;
class CarouselCard {
}
exports.CarouselCard = CarouselCard;
class CatalogItem {
}
exports.CatalogItem = CatalogItem;
/**
 * Content creation request body
 */
class ContentCreateRequest {
}
exports.ContentCreateRequest = ContentCreateRequest;
/**
 * Content update request body
 */
class ContentUpdateRequest {
}
exports.ContentUpdateRequest = ContentUpdateRequest;
class FlowsPage {
}
exports.FlowsPage = FlowsPage;
class FlowsPageComponent {
}
exports.FlowsPageComponent = FlowsPageComponent;
class ListItem {
}
exports.ListItem = ListItem;
class QuickReplyAction {
}
exports.QuickReplyAction = QuickReplyAction;
/**
 * twilio/call-to-action buttons let recipients tap to trigger actions such as launching a website or making a phone call.
 */
class TwilioCallToAction {
}
exports.TwilioCallToAction = TwilioCallToAction;
/**
 * twilio/card is a structured template which can be used to send a series of related information. It must include a title and at least one additional field.
 */
class TwilioCard {
}
exports.TwilioCard = TwilioCard;
/**
 * twilio/carousel templates allow you to send a single text message accompanied by a set of up to 10 carousel cards in a horizontally scrollable view
 */
class TwilioCarousel {
}
exports.TwilioCarousel = TwilioCarousel;
/**
 * twilio/catalog type lets recipients view list of catalog products, ask questions about products, order products.
 */
class TwilioCatalog {
}
exports.TwilioCatalog = TwilioCatalog;
/**
 * twilio/flows templates allow you to send multiple messages in a set order with text or select options
 */
class TwilioFlows {
}
exports.TwilioFlows = TwilioFlows;
/**
 * twilio/list-picker includes a menu of up to 10 options, which offers a simple way for users to make a selection.
 */
class TwilioListPicker {
}
exports.TwilioListPicker = TwilioListPicker;
/**
 * twilio/location type contains a location pin and an optional label, which can be used to enhance delivery notifications or connect recipients to physical experiences you offer.
 */
class TwilioLocation {
}
exports.TwilioLocation = TwilioLocation;
/**
 * twilio/media is used to send file attachments, or to send long text via MMS in the US and Canada. As such, the twilio/media type must contain at least ONE of text or media content.
 */
class TwilioMedia {
}
exports.TwilioMedia = TwilioMedia;
/**
 * twilio/quick-reply templates let recipients tap, rather than type, to respond to the message.
 */
class TwilioQuickReply {
}
exports.TwilioQuickReply = TwilioQuickReply;
/**
 * twilio/schedule templates allow us to send a message with a schedule with different time slots
 */
class TwilioSchedule {
}
exports.TwilioSchedule = TwilioSchedule;
/**
 * Type containing only plain text-based content
 */
class TwilioText {
}
exports.TwilioText = TwilioText;
/**
 * Content types
 */
class Types {
}
exports.Types = Types;
/**
 * whatsApp/authentication templates let companies deliver WA approved one-time-password button.
 */
class WhatsappAuthentication {
}
exports.WhatsappAuthentication = WhatsappAuthentication;
/**
 * whatsapp/card is a structured template which can be used to send a series of related information. It must include a body and at least one additional field.
 */
class WhatsappCard {
}
exports.WhatsappCard = WhatsappCard;
/**
 * whatsapp/flows templates allow you to send multiple messages in a set order with text or select options
 */
class WhatsappFlows {
}
exports.WhatsappFlows = WhatsappFlows;
class ContentContextImpl {
    constructor(_version, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { sid };
        this._uri = `/Content/${sid}`;
    }
    get approvalCreate() {
        this._approvalCreate =
            this._approvalCreate ||
                (0, approvalCreate_1.ApprovalCreateListInstance)(this._version, this._solution.sid);
        return this._approvalCreate;
    }
    get approvalFetch() {
        this._approvalFetch =
            this._approvalFetch ||
                (0, approvalFetch_1.ApprovalFetchListInstance)(this._version, this._solution.sid);
        return this._approvalFetch;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ContentInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "put",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ContentInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ContentContextImpl = ContentContextImpl;
class ContentInstance {
    constructor(_version, payload, sid) {
        this._version = _version;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.sid = payload.sid;
        this.accountSid = payload.account_sid;
        this.friendlyName = payload.friendly_name;
        this.language = payload.language;
        this.variables = payload.variables;
        this.types = payload.types;
        this.url = payload.url;
        this.links = payload.links;
        this._solution = { sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new ContentContextImpl(this._version, this._solution.sid);
        return this._context;
    }
    /**
     * Remove a ContentInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a ContentInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ContentInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Access the approvalCreate.
     */
    approvalCreate() {
        return this._proxy.approvalCreate;
    }
    /**
     * Access the approvalFetch.
     */
    approvalFetch() {
        return this._proxy.approvalFetch;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            sid: this.sid,
            accountSid: this.accountSid,
            friendlyName: this.friendlyName,
            language: this.language,
            variables: this.variables,
            types: this.types,
            url: this.url,
            links: this.links,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ContentInstance = ContentInstance;
function ContentListInstance(version) {
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new ContentContextImpl(version, sid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Content`;
    instance.create = function create(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ContentInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ContentPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new ContentPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class ContentPage extends Page_1.default {
    /**
     * Initialize the ContentPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of ContentInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new ContentInstance(this._version, payload);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ContentPage = ContentPage;
