'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('agreements', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      property_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: true
      },
      tenant_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: true
      },
      rent_amount: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      deposit_amount: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      start_date: {
        type: Sequelize.STRING(20), // You can use Sequelize.DATE if needed
        allowNull: true
      },
      end_date: {
        type: Sequelize.STRING(20),
        allowNull: true
      },
      next_incr_date: {
        type: Sequelize.STRING(20),
        allowNull: true
      },
      payment_frequency: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      next_agree_amount_type: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      next_agree_amount: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      terms_condition: {
        type: Sequelize.TEXT('long'),
        allowNull: true
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false
      },
      created_at: {
        allowNull: true,
        type: Sequelize.DATE
      },
      updated_at: {
        allowNull: true,
        type: Sequelize.DATE
      },
      
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('agreements');
  }
};
