'use strict';
module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('recurring_invoice_items', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      recurring_invoice_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        references: {
          model: 'recurring_invoices', // ✅ Fixed reference
          key: 'id'
        },
        onDelete: 'CASCADE',
        onUpdate: 'CASCADE' // ✅ Optional, good for completeness
      },
      code: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      title: {
        type: Sequelize.STRING(1000),
        allowNull: false
      },
      amount: {
        type: Sequelize.DOUBLE(15, 2),
        allowNull: false,
        defaultValue: 0.00
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: true
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: true
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('recurring_invoice_items');
  }
};
