'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('client', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
      },
      first_name: {
        type: Sequelize.STRING(255),
        allowNull: false,
      },
      last_name: {
        type: Sequelize.STRING(255),
        allowNull: true,
      },
      ssn: {
        type: Sequelize.STRING(20),
        allowNull: true,
      },
      id_type: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      id_number: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      phone: {
        type: Sequelize.STRING(20),
        allowNull: true,
      },
      email: {
        type: Sequelize.STRING(255),
        allowNull: true,
      },
      gender: {
        type: Sequelize.ENUM('male', 'female', 'other'),
        allowNull: true,
      },
      date_of_birth: {
        type: Sequelize.DATEONLY,
        allowNull: true,
      },
      opening_balance: {
        type: Sequelize.DOUBLE,
        allowNull: false,
        defaultValue: 0,
      },
      monthly_gross_income: {
        type: Sequelize.DOUBLE,
        allowNull: false,
        defaultValue: 0,
      },
      additional_income: {
        type: Sequelize.DOUBLE,
        allowNull: false,
        defaultValue: 0,
      },
      marital_status: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      ethnicity: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      corporation_name: {
        type: Sequelize.STRING(255),
        allowNull: true,
      },
      ein: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      street_number: {
        type: Sequelize.STRING(255),
        allowNull: true,
      },
      suite_floor: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      zip_code: {
        type: Sequelize.STRING(20),
        allowNull: true,
      },
      city: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      state: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      country: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      mailing_address: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      notes: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      status: {
        type: Sequelize.ENUM('active', 'inactive'),
        allowNull: false,
        defaultValue: 'active',
      },
      created_by: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: false,
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: true,
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: true,
      },
    });
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('client');
  },
};
