module.exports = (sequelize, DataTypes) => {
  const ClientRevenueReceived = sequelize.define(
    'client_revenue_received',
    {
      id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true, 
      },
      client_id: {  
        type: DataTypes.BIGINT.UNSIGNED, 
        allowNull: false,
      },
      revenue_id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
      },
      created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
      },
      updated_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      tableName: 'client_revenue_received',
      timestamps: false,
    }
  );

  ClientRevenueReceived.associate = (models) => {
    ClientRevenueReceived.belongsTo(models.client, {
      foreignKey: 'client_id',
      as: 'client',
    });

    ClientRevenueReceived.belongsTo(models.revenue_received, {
      foreignKey: 'revenue_id',
      as: 'revenue',
    });
  };

  return ClientRevenueReceived;
};
