module.exports = function (sequelize, DataTypes) {
  const Leave = sequelize.define('leave', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    employee_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    leave_type: {
      type: DataTypes.STRING,
      allowNull: true, // Changed to nullable
    },
    department: {
      type: DataTypes.STRING,
      allowNull: true, // Changed to nullable
    },
    designation: {
      type: DataTypes.STRING,
      allowNull: true, // Changed to nullable
    },
    employee_type: {
      type: DataTypes.STRING,
      allowNull: true, // Changed to nullable
    },
    status: {
      type: DataTypes.STRING,
      allowNull: false,
      defaultValue: 'pending', // Added default
    },
    duration: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    date: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    date_range: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    reason: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    file: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true, // Changed to nullable
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'leaves',
  });

  Leave.associate = function (models) {
    Leave.belongsTo(models.employee, {
      foreignKey: 'employee_id',
      as: 'employee',
    });

    Leave.belongsTo(models.leave_type, {
      foreignKey: 'leave_type',
      targetKey: 'id',
      as: 'leaveType',
    });
  };

  return Leave;
};