module.exports = function (sequelize, DataTypes) {
    const RevenueReceived = sequelize.define('revenue_received', {
        id: {
            type: DataTypes.BIGINT.UNSIGNED,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        unit_id: {
            type: DataTypes.BIGINT.UNSIGNED,
            allowNull: false,
        },
        type: {
            type: DataTypes.STRING(255),
            allowNull: true,
        },
        invoice_ids: {
            type: DataTypes.JSON,
            allowNull: true,
        },
        payment_mode: {
            type: DataTypes.STRING(50),
            allowNull: false,
        },
        amount: {
            type: DataTypes.DOUBLE(15, 2),
            allowNull: false,
            defaultValue: 0.00,
        },
        cheque_number: {
            type: DataTypes.STRING(100),
            allowNull: true,
        },
        routing_number: {
            type: DataTypes.STRING(100),
            allowNull: true,
        },
        cheque_due_date: {
            type: DataTypes.DATE,
            allowNull: true,
        },
        account_number: {
            type: DataTypes.STRING(100),
            allowNull: true,
        },
        cheque_status: {
            type: DataTypes.STRING(50),
            allowNull: true,
        },
        card_number: {
            type: DataTypes.STRING(100),
            allowNull: true,
        },
        barter_description: {
            type: DataTypes.TEXT('long'),
            allowNull: true,
        },
        zelle_description: {
            type: DataTypes.TEXT('long'),
            allowNull: true,
        },
        created_by: {
            type: DataTypes.BIGINT.UNSIGNED,
            allowNull: true,
        },
        createdAt: {
            field: 'created_date',
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
        },
        updatedAt: {
            field: 'updated_date',
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
        }
    }, {
        timestamps: true,
        underscored: true,
        freezeTableName: true,
        tableName: 'revenue_received',
    });

    RevenueReceived.associate = (models) => {
        RevenueReceived.hasMany(models.tenant_revenue_received, {
            foreignKey: 'revenue_id',
            as: 'tenant_revenues',
        });

        RevenueReceived.hasMany(models.client_revenue_received, {
            foreignKey: 'revenue_id',
            as: 'client_revenues',
        });

    };

    return RevenueReceived;
};