/// <reference types="node" />
import { EventEmitter } from 'events';
import { PubSubEngine } from './pubsub-engine';
export interface PubSubOptions {
    eventEmitter?: EventEmitter;
}
export declare class PubSub implements PubSubEngine {
    protected ee: EventEmitter;
    private subscriptions;
    private subIdCounter;
    constructor(options?: PubSubOptions);
    publish(triggerName: string, payload: any): boolean;
    subscribe(triggerName: string, onMessage: (...args: any[]) => void): Promise<number>;
    unsubscribe(subId: number): void;
    asyncIterator<T>(triggers: string | string[]): AsyncIterator<T>;
}
